//Source file: H:\middleware\src\Alkindi\BusinessServices\Util\PCDataByUser.java

package Alkindi.Services.InternalData;

import java.sql.ResultSet;
import java.sql.SQLException;

/* 
$Header: PCRecData.java, 13, 4/26/01 2:36:58 PM, Schwartz, Joe$
$Log: 
 13   Alkindi Development1.12        4/26/01 2:36:58 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 12   Alkindi Development1.11        4/26/01 1:46:06 PM   Schwartz, Joe   Moved
      to new package.
 11   Alkindi Development1.10        2/19/01 6:16:15 PM   Schwartz, Joe   Added
      fromResultSet() generator method.
 10   Alkindi Development1.9         2/16/01 5:49:08 PM   Schwartz, Joe   Added
      SQLData implementation. Modified class members to match Oracle UDTs.
 9    Alkindi Development1.8         2/12/01 4:47:45 PM   Schwartz, Joe  
      Changed to account for Product ID becoming an int.
 8    Alkindi Development1.7         12/28/00 1:07:27 PM  Schwartz, Joe   Added
      Version Control header info.
 7    Alkindi Development1.6         12/26/00 6:57:14 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/19/00 5:42:16 PM  Schwartz, Joe   
 5    Alkindi Development1.4         12/19/00 2:54:11 PM  Schwartz, Joe   
 4    Alkindi Development1.3         12/19/00 2:51:32 PM  Schwartz, Joe   
 3    Alkindi Development1.2         12/19/00 2:51:13 PM  Schwartz, Joe   Added
      calcWeight function to class.
 2    Alkindi Development1.1         12/18/00 4:51:44 PM  Schwartz, Joe   
 1    Alkindi Development1.0         11/8/00 3:00:20 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Represents a statisical data for a single User and Product Cluster. It is used to calculate a Recommendation weight for that Product Cluster.<br>
 * This class provides a static method to parse an instance of the class from a ResultSet.
 * <p>
 * @see Alkindi.Services.ServicesImpl.RecommendationManager
 */
public class PCRecData 
{
	
	/**
	 * User's average product evaluation within this Product Cluster.
	 */
	public float avgEval = 0;
	
	/**
	 * The User's evaluation statistics for products in this product cluster.
	 */
	public UserEvalData evalData = null;
	
	/**
	 * The number of Recommendable products in this PC.
	 */
	public int numRecProds = 0;
	
	/**
	 * The ID of the Product Cluster for which this class represents data.
	 */
	public int pcID = 0;
	
	/**
	 * Flag to indicate whether the user is clustered with respect to the Product Cluster.
	 */
	public boolean userClustered = false;
	
	public PCRecData() 
	{
	}
	
	/**
	 * Parses the current record into a new instance of PCRecData.
	 * @roseuid 3A9194C40157
	 */
	public static PCRecData fromResultSet(java.sql.ResultSet rsIn) throws SQLException 
	{
		PCRecData pcData = new PCRecData();
		pcData.pcID = rsIn.getInt(1);
		pcData.numRecProds = rsIn.getInt(2);
		pcData.avgEval = rsIn.getFloat(3);
		pcData.userClustered = rsIn.getString(4).equals("Y");
		pcData.evalData = new UserEvalData();
		pcData.evalData.numDunno = rsIn.getInt(5);
		pcData.evalData.numNo = rsIn.getInt(6);
		pcData.evalData.numYes = rsIn.getInt(7);
		for (int idx = 0; idx < 7; idx ++) {
			pcData.evalData.ratingSums[idx] = rsIn.getInt(idx + 8);
		}
		return pcData;
	}
}
